
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include "../MachineInterface.h"
#include "../nr_lib/nr_lib.h"

CMachineParameter const paraDetail = 
{ 
	pt_byte,										// type
	"Detail",
	"Detail",										// description
	1,												// MinValue	
	16,											// MaxValue
	0,												// NoValue
	MPF_STATE,										// Flags
	1
};

CMachineParameter const paraSeekRate = 
{ 
	pt_word,										// type
	"Rate",
	"Change Rate (half life in ms)",				// description
	1,												// MinValue	
	0xFFFF,											// MaxValue
	0,												// NoValue
	MPF_STATE,										// Flags
	125
};

CMachineParameter const paraInit = 
{ 
	pt_word,										// type
	"Initial",
	"Level [initialise] (0=-200%, 8000=0%, FFFE=~200%)",	// description
	0,												// MinValue	
	0xfffe,											// MaxValue
	0xffff,    										// NoValue
	MPF_STATE,										// Flags
	0x8000
};

CMachineParameter const paraTarget = 
{ 
	pt_word,										// type
	"Target",
	"Level [target] (0=-200%, 8000=0%, FFFE=~200%)",	// description
	0,												// MinValue	
	0xfffe,											// MaxValue
	0xffff,    										// NoValue
	MPF_STATE,										// Flags
	0x8000
};

CMachineParameter const *pParameters[] = 
{ 
	// global
	&paraDetail,
	&paraSeekRate,
	&paraInit,
	&paraTarget
};

#pragma pack(1)		

class gvals
{
public:
	byte detail;
	word seek_rate;
	word initial;
	word target;
};

#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_EFFECT,								// type
	MI_VERSION,	
	0,										// flags
	0,										// min tracks
	0,										// max tracks
	4,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	NULL,
#ifdef _DEBUG
	"Ninereeds Discretize (Debug build)",		// name
#else
	"Ninereeds Discretize",					// name
#endif
	"Discrete",								// short name
	"Steve Horne",							// author
	NULL
};


class mi : public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Init(CMachineDataInput * const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);

private:
			
	

private:
	int   Detail;

	c_Decay_Simple *f_Decay;

//	float AttackA;
//	float AttackB;
	
//	float Target;
//	float Current;

	gvals gval;

};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
	f_Decay = NULL;
//	AttrVals = (int *)&aval;
}

mi::~mi()
{
	if (f_Decay != NULL)  {  delete f_Decay;  }
}

void mi::Init(CMachineDataInput * const pi)
{
	Detail = 1;

	f_Decay = new c_Decay_Simple (pMasterInfo->SamplesPerSec);

	f_Decay->Tick (125, 0, 0);

//	AttackA = pow(2.0, -1000.0 / (((double) pMasterInfo->SamplesPerSec) * 125.0));
//	AttackB = 1.0 - AttackA;
	
//	Target  = 0.0;
//	Current = 0.0;
}

void mi::Tick()
{
	if (gval.detail != paraDetail.NoValue)
	{
		Detail = gval.detail;
	}

	f_Decay->Tick (gval.seek_rate, gval.target, gval.initial);
/*
	if (gval.seek_rate != paraSeekRate.NoValue)
	{
		AttackA = pow(2.0, -1000.0 / (((double) pMasterInfo->SamplesPerSec) * ((float) gval.seek_rate)));
		AttackB = 1.0 - AttackA;
	}

	if (gval.initial != paraInit.NoValue)
	{
		Current = ((float) (gval.initial - 0x8000)) / 16384.0;
		Target  = Current;
	}

	if (gval.target != paraTarget.NoValue)
	{
		Target = ((float) (gval.target - 0x8000)) / 16384.0;
	}
*/
}


bool mi::Work(float *psamples, int numsamples, int const mode)
{
	if (mode == WM_WRITE || mode == WM_NOIO)
		return false;
	
	if (mode == WM_READ)
		return true;

	float Tmp;
	float Tmp2;
	float Tmp3;

	Tmp3 = ((float) (Detail + Detail));

  if (f_Decay->Is_Static ())
  {
    float l_Level = f_Decay->Current_Level ();

    if (l_Level != 1.0)
    {
//      l_Level -= 1.0;

      do
      {
        Tmp = ((((*psamples) / 65536.0) + 0.5) * Tmp3) + 0.5;

        Tmp = (float) ((int) Tmp);
		
        Tmp = ((Tmp / Tmp3) - 0.5) * 65536.0;
        Tmp2 = (*psamples) - Tmp;

        (*psamples) += (Tmp2 * l_Level);

        psamples++;

      } while (--numsamples);
    }
  }
  else
  {
  	float *l_Aux_Buf = pCB->GetAuxBuffer ();

    f_Decay->Overwrite (l_Aux_Buf, numsamples);

    do
    {
      Tmp = ((((*psamples) / 65536.0) + 0.5) * Tmp3) + 0.5;

      Tmp = (float) ((int) Tmp);
		
      Tmp = ((Tmp / Tmp3) - 0.5) * 65536.0;
      Tmp2 = (*psamples) - Tmp;

//      (*psamples) += (Tmp2 * (*l_Aux_Buf - 1.0));
      (*psamples) += (Tmp2 * (*l_Aux_Buf));

      psamples++;
      l_Aux_Buf++;

    } while (--numsamples);
  }

	return true;
}
